/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.transport.SipMessage;

public abstract class MessageSender {
    public static final int KEEY_ALIVE_INTERVAL = 25;
    protected InetAddress inetAddress;
    protected int port;
    protected int localPort;
    private Config config;
    private String transportName;
    private Timer timer;
    protected Logger logger;

    public MessageSender(int localPort, InetAddress inetAddress, int port, Config config, String transportName, Logger logger) {
        this.localPort = localPort;
        this.inetAddress = inetAddress;
        this.port = port;
        this.config = config;
        this.transportName = transportName;
        this.timer = new Timer(this.getClass().getSimpleName() + " " + Timer.class.getSimpleName());
        this.logger = logger;
        this.timer.scheduleAtFixedRate((TimerTask)new KeepAlive(), 0L, 25000L);
    }

    public abstract void sendMessage(SipMessage var1) throws IOException;

    public abstract void sendBytes(byte[] var1) throws IOException;

    public String getContact() {
        StringBuffer buf = new StringBuffer();
        InetAddress myAddress = this.config.getPublicInetAddress();
        if (myAddress == null) {
            myAddress = this.config.getLocalInetAddress();
        }
        buf.append(myAddress.getHostAddress());
        buf.append(':');
        buf.append(this.localPort);
        buf.append(";");
        buf.append("transport");
        buf.append("=");
        buf.append(this.transportName);
        return buf.toString();
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void stopKeepAlives() {
        this.timer.cancel();
    }

    class KeepAlive
    extends TimerTask {
        KeepAlive() {
        }

        @Override
        public void run() {
            byte[] bytes = "\r\n\r\n".getBytes();
            try {
                MessageSender.this.sendBytes(bytes);
            }
            catch (IOException e) {
                MessageSender.this.logger.error(e.getMessage(), e);
            }
        }
    }
}

